﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net


using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceModel.Syndication;
using System.Windows.Forms;

namespace ServiceModelEx.ServiceBus
{
   public partial class ServiceBusGraph2
   {    
      void Consolidate(List<ServiceBusNode> nodes)
      {
         // Routery i bufory subksrybenta - odpowiednie elementy są wyświetlane dwukrotnie: raz w formie routerów lub kolejek i raz w formie strategii.
         // Zachowywane są tylko strategie.
         List<ServiceBusNode> nodesToRemove = new List<ServiceBusNode>();
         uint policiesCount = 0;

         foreach(ServiceBusNode junction in nodes)
         {
            if(junction.Policy != null)
            {
               policiesCount++;
               foreach(ServiceBusNode service in nodes)
               {
                  if(service.Name == junction.Name && service.Policy == null)
                  {
                     nodesToRemove.Add(service);
                     junction.AddSubscribedTo(service.SubscribedTo);
                     foreach(ServiceBusNode node in nodes)
                     {
                        node.ReplaceSubscriber(service,junction);
                     }
                  }
               }
            }
         }
         if(policiesCount < nodesToRemove.Count)
         {
            MessageBox.Show("Kanał przestrzeni nazw zawiera pewne nieścisłości","Eksplorator magistrali usług",MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
         }

         foreach(ServiceBusNode nodeToRemove in nodesToRemove)
         {
            nodes.Remove(nodeToRemove);
         }

         nodesToRemove.Clear();

         // Zachowuje tylko elementy najwyższego poziomu
         foreach(ServiceBusNode node in nodes)
         {
            if(node.SubscribedTo != null)
            {
               nodesToRemove.Add(node);
            }
         }

         foreach(ServiceBusNode node in nodesToRemove)
         {
            nodes.Remove(node);
         }

         // Usuwa wszystkie identyfikatory URI będące przedrostkami innych identyfikatorów (czyli ścieżki prowadzące do adresów reprezentowanych przez inne linki)
         nodesToRemove.Clear();

         foreach(ServiceBusNode part in nodes)
         {
            foreach(ServiceBusNode node in nodes)
            {
               if(node != part && node.Name.StartsWith(part.Name,StringComparison.OrdinalIgnoreCase))
               {
                  if(nodesToRemove.Contains(part) == false)
                  {
                     nodesToRemove.Add(part);
                  }
               }
            }
         }

         foreach(ServiceBusNode node in nodesToRemove)
         {
            nodes.Remove(node);
         }
      }
      void AssertIntegrery(ServiceBusNode[] array)
      {
         foreach(ServiceBusNode node in array)
         {
            if(node.SubscribersCount > 0)
            {
               Debug.Assert(node.Subscribers != null);
               foreach(ServiceBusNode subscriber in node.Subscribers)
               {
                  subscriber.SubscribedTo.Contains(node);
               }
            }
         }
      }
      static bool IsJunction(SyndicationItem item)
      {
         if(item.ElementExtensions.Count == 1)
         {
            return item.ElementExtensions[0].OuterName.Contains("Policy");
         }
         return false;
      }
      RouterPolicy GetRouterPolicy(string address)
      {
         address = address.Replace(@"https://",@"sb://");
         address = address.Replace(@"http://",@"sb://");

         Uri routerAddress = new Uri(address);

         return RouterManagementClient.GetRouterPolicy(Credential,routerAddress);
      }
   }
}